import org.uddi4j.client.UDDIProxy;
import org.uddi4j.datatype.Name;
import org.uddi4j.datatype.assertion.PublisherAssertion;
import org.uddi4j.datatype.tmodel.TModel;
import org.uddi4j.response.AuthToken;
import org.uddi4j.response.BusinessInfo;
import org.uddi4j.response.BusinessInfos;
import org.uddi4j.response.BusinessList;
import org.uddi4j.response.PublisherAssertions;
import org.uddi4j.transport.TransportFactory;
import org.uddi4j.util.KeyedReference;
import java.security.Security;
import java.util.Vector;

public class UDDISetPublisherAssertions1 {

	public static void main(String[] args) throws Exception {

		System.setProperty("java.protocol.handler.pkgs", "com.sun.net.ssl.internal.www.protocol");      
		Security.addProvider(new com.sun.net.ssl.internal.ssl.Provider());

		System.setProperty(TransportFactory.PROPERTY_NAME, "org.uddi4j.transport.ApacheAxisTransport");

		UDDIProxy proxy = new UDDIProxy();
		proxy.setInquiryURL("http://uddi.microsoft.com/inquire");
		proxy.setPublishURL("https://uddi.microsoft.com/publish");

		Vector names = new Vector();
		names.add(new Name("Services Web & compagnie"));
		names.add(new Name("WS-I organization"));
		BusinessList bl = proxy.find_business(names, null, null, null, null, null, 0);

		BusinessInfos bis = bl.getBusinessInfos();
		if (bis.size() == 0) {
			System.out.println("no business(es) found");
			System.exit(0);
		}

		System.out.println(bis.size()+" business(es) found\n");
		if (bis.size() < 2 || bis.size() > 2) {
			System.out.println("invalid number of business(es) found");
			System.exit(0);
		}

		Vector biv = bis.getBusinessInfoVector();
		for (int i = 0; i < biv.size(); i++) {
			BusinessInfo bi = (BusinessInfo)biv.elementAt(i);
			System.out.println(bi.getNameString());
			System.out.println(bi.getBusinessKey());
			System.out.println("\n");
		}

		AuthToken at = proxy.get_authToken("user", "password");

		PublisherAssertion pa = new PublisherAssertion();
		pa.setFromKeyString(((BusinessInfo)biv.elementAt(0)).getBusinessKey());
		pa.setToKeyString(((BusinessInfo)biv.elementAt(1)).getBusinessKey());
		pa.setKeyedReference(new KeyedReference("Community Member", "identity", TModel.RELATIONSHIPS_TMODEL_KEY));

//		PublisherAssertions pas = proxy.set_publisherAssertions(at.getAuthInfoString(), pa);
		PublisherAssertions pas = proxy.set_publisherAssertions(at.getAuthInfoString(), new Vector());

		Vector pav = pas.getPublisherAssertionVector();
		if (pav.size() == 0) {
			System.out.println("no publisher assertion(s) found");
		}
		else {
			System.out.println(pav.size()+" publisher assertion(s) found\n");
			for (int i = 0; i < pav.size(); i++) {
				pa = (PublisherAssertion)pav.elementAt(i);
				System.out.println("fromKey : "+pa.getFromKeyString());
				System.out.println("toKey   : "+pa.getToKeyString());
				System.out.println("name    : "+pa.getKeyedReference().getKeyName());
				System.out.println("value   : "+pa.getKeyedReference().getKeyValue());
				System.out.println("\n");
			}
		}
		proxy.discard_authToken(at.getAuthInfo());
	}
}